#!/bin/bash

current_dir=$( dirname -- "$0"; )
echo $current_dir

pdes=(
    "--hidden_layers 8 --eqn conv-1d --use_pdebench --data_seed 40 --const 1.0 --train_steps 200000 --num_points 200 --mem_pts_total_budget 1000"
    "--hidden_layers 8 --eqn conv-1d --use_pdebench --data_seed 40 --const 1.0 --no-allow_ic --inverse --inverse_guess 0.8 --train_steps 200000 --al_every 1000 --select_anchors_every 10000 --num_points 200 --mem_pts_total_budget 1000 --anchor_budget 5"
    "--hidden_layers 8 --eqn conv-1d --use_pdebench --data_seed 80 --const 1.0 --train_steps 200000 --num_points 200 --mem_pts_total_budget 1000"
    "--hidden_layers 8 --eqn conv-1d --use_pdebench --data_seed 80 --const 1.0 --no-allow_ic --inverse --inverse_guess 0.8 --train_steps 200000 --al_every 1000 --select_anchors_every 10000 --num_points 200 --mem_pts_total_budget 1000 --anchor_budget 5"
    "--hidden_layers 4 --eqn burgers-1d --use_pdebench --data_seed 20 --const 0.02 --train_steps 200000 --num_points 100 --mem_pts_total_budget 300"
    "--hidden_layers 4 --eqn burgers-1d --use_pdebench --no-allow_ic --data_seed 20 --const 0.02 --inverse --inverse_guess 0.04 --train_steps 200000 --al_every 1000 --select_anchors_every 10000 --num_points 100 --mem_pts_total_budget 300 --anchor_budget 5"
    "--hidden_layers 4 --eqn burgers-1d --use_pdebench --data_seed 40 --const 0.02 --train_steps 200000 --num_points 100 --mem_pts_total_budget 300"
    "--hidden_layers 4 --eqn burgers-1d --use_pdebench --no-allow_ic --data_seed 40 --const 0.02 --inverse --inverse_guess 0.04 --train_steps 200000 --al_every 1000 --select_anchors_every 10000 --num_points 100 --mem_pts_total_budget 300 --anchor_budget 5"
    "--hidden_layers 6 --nn laaf --hidden_dim 64 --eqn fd-2d --const 1.0 0.01 --no-allow_ic --anc_measurable_idx 0 1 --inverse --inverse_guess 0 0 --train_steps 100000 --al_every 1000 --select_anchors_every 1000 --num_points 200 --mem_pts_total_budget 1000 --anchor_budget 30"
)

algs=(
    "--method random --rand_method pseudo --rand_res_prop 0.5"
    "--method random --rand_method pseudo --rand_res_prop 0.8"
    "--method random --rand_method pseudo --rand_res_prop 0.95"
    "--method random --rand_method Hammersley --rand_res_prop 0.5"
    "--method random --rand_method Hammersley --rand_res_prop 0.8"
    "--method random --rand_method Hammersley --rand_res_prop 0.95"
    "--method random --rand_method Sobol --rand_res_prop 0.5"
    "--method random --rand_method Sobol --rand_res_prop 0.8"
    "--method random --rand_method Sobol --rand_res_prop 0.95"
    "--method residue --res_res_prop 0.5"
    "--method residue --res_res_prop 0.5 --res_all_types"
    "--method residue --res_res_prop 0.8"
    "--method residue --res_res_prop 0.8 --res_all_types"
    "--method residue --res_res_prop 0.95"
    "--method residue --res_res_prop 0.95 --res_all_types"
    "--method kmeans --eig_weight_method alignment --eig_sampling pseudo --eig_memory --auto_al"
    "--method sampling --eig_weight_method alignment --eig_sampling pseudo --eig_memory --auto_al"
    "--method kmeans --eig_weight_method alignment --eig_sampling pseudo --auto_al"
    "--method sampling --eig_weight_method alignment --eig_sampling pseudo --auto_al"
    "--method kmeans --eig_weight_method alignment --eig_sampling pseudo --eig_memory"
    "--method sampling --eig_weight_method alignment --eig_sampling pseudo --eig_memory"
)

losses=(
    "--loss_w_bcs 1.0"
)

for j in $3; do

    for k in $1; do

        pde="${pdes[$k]}"
        echo "PDE params: $pde"

        for loss in "${losses[@]}"; do

            for m in $2; do

                alg="${algs[$m]}"

                pdeargs="$pde $alg $loss $4"

                python ${current_dir}/al_pinn.py $pdeargs
                
            done

        done

    done

done