# Privacy-Preserving LLM Interaction

## 🧠 Available Vector DBs

- `naive`
- `milvus`
- `hevec`

## 🤖 Available Models

### Retriever

- `bm25`
- `sbert`
- `dpr`
- `contriever`
- `instructor`
- `dragon`

### Generator

- `gpt-4o`
- `gemini-1.5-pro`
- `claude-3-5-sonnet-20241022`
- `llama3.2:1b`
- `llama3.2:3b`
- `llama3.1:8b`
- `llama3.3:70b`

## 🧚 Guide Code

If you want to understand the secure inner product algorithm in detail, refer to the [secure_inner_product.ipynb](notebooks/guide_code/secure_inner_product.ipynb) file or [hevec](hevec) directory.

## 💾 Data Schema

For detailed information on the data schema, refer to the [SCHEMA.md](src/schema/SCHEMA.md).

## 🛠️ Installation

```sh
# clone repository
git clone git@github.com:anonymized/privacy-preserving-llm-interaction.git

# install git lfs
brew install git-lfs
git lfs install
git lfs fetch
git lfs pull

# install pre-commit
brew install pre-commit
pre-commit install

# install poetry
brew install poetry

# or you can install poetry using pip
pip install poetry

# install libraries
poetry install

# install torch
poetry shell
pip install torch
exit
```

## ⛰️ Memory DB Construction

```sh
# use sparse retriever (e.g. BM25)
sh scripts/peliqan/construct_sparse_memory_db.sh

# or use dense retriever (e.g. DPR)
sh scripts/peliqan/construct_dense_memory_db.sh
```

## 📝 Benchmark Evaluation

```sh
# step 1. get inference results
sh scripts/peliqan/infer_naive_rag.sh

# step 2. get evaluation report
sh scripts/peliqan/eval_naive_rag.sh
```

## 👻 Gradio Demo (Deprecated)

```sh
# run demo
sh scripts/run_demo.sh
```

## 🙌 Contribution Guide

### Branch Naming

- Feature Branches: For new features.
- Bugfix Branches: For fixing bugs.
- Hotfix Branches: For urgent fixes to production.
- Release Branches: For preparing a new production release.
- Chore Branches: For maintenance tasks.

### Commit Message Convention

For more detail, refer to https://www.conventionalcommits.org/en/v1.0.0/.

- Types: Describes the category of the change.
    - feat: A new feature for a specific project.
    - fix: A bug fix for a specific project.
    - docs: Documentation changes.
    - style: Code style changes (formatting, missing semi-colons, etc.).
    - refactor: Code refactoring without changing functionality.
    - perf: Performance improvements.
    - test: Adding or updating tests.
    - chore: Changes to the build process or auxiliary tools and libraries.
