#include <iostream>
#include <vector>

#include "evd/Ciphertext.hpp"
#include "evd/Client.hpp"
#include "evd/Const.hpp"
#include "evd/HEval.hpp"
#include "evd/Message.hpp"
#include "evd/SecretKey.hpp"
#include "evd/SwitchingKey.hpp"

using namespace evd;

constexpr u64 LOG_RANK = 7;
constexpr u64 RANK = 1ULL << LOG_RANK;
constexpr u64 STACK = DEGREE >> LOG_RANK;

int main() {
  Client client(LOG_RANK);
  SecretKey secKey;

  client.genSecKey(secKey);

  std::vector<Message> msgs;
  std::vector<MLWECiphertext> ctxts;

  msgs.reserve(STACK);
  ctxts.reserve(STACK);
  for (u64 i = 0; i < STACK; ++i) {
    msgs.emplace_back(RANK);
    for (u64 j = 0; j < RANK; ++j)
      msgs[i][j] = static_cast<double>(i * RANK + j);
    ctxts.emplace_back(RANK);
    client.encrypt(ctxts[i], msgs[i], secKey, std::pow(2.0, LOG_SCALE));
  }

  std::vector<SwitchingKey> modPackKeys;
  client.genModPackKeys(modPackKeys, secKey);

  HEval eval(LOG_RANK);

  Ciphertext ctxt;
  eval.modPack(ctxt, ctxts, modPackKeys);

  Message dmsg(DEGREE);
  client.decrypt(dmsg, ctxt, secKey, std::pow(2.0, LOG_SCALE));
  double max_error = 0;
  for (u64 i = 0; i < DEGREE; ++i) {
    max_error =
        std::max(max_error, std::abs(msgs[i % STACK][i / STACK] - dmsg[i]));
  }
  std::cout << max_error << std::endl;
}