#include <iostream>
#include <vector>

#include "evd/Ciphertext.hpp"
#include "evd/Client.hpp"
#include "evd/Const.hpp"
#include "evd/HEval.hpp"
#include "evd/MLWECiphertext.hpp"
#include "evd/Message.hpp"
#include "evd/SecretKey.hpp"
#include "evd/SwitchingKey.hpp"

using namespace evd;

constexpr u64 LOG_RANK = 7;
constexpr u64 RANK = 1ULL << LOG_RANK;
constexpr u64 STACK = DEGREE >> LOG_RANK;
constexpr u64 EXPONENT = 3;

int main() {
  Client client(LOG_RANK);
  SecretKey secKey;

  client.genSecKey(secKey);

  HEval eval(LOG_RANK);

  std::vector<Message> msgs;
  std::vector<MLWECiphertext> ctxts;
  MLWECiphertext temp(RANK);

  msgs.reserve(STACK);
  ctxts.reserve(STACK);
  for (u64 i = 0; i < STACK; ++i) {
    msgs.emplace_back(RANK);
    for (u64 j = 0; j < RANK; ++j)
      msgs[i][j] = static_cast<double>(i * RANK + j);
    ctxts.emplace_back(RANK);
    client.encrypt(temp, msgs[i], secKey, std::pow(2.0, LOG_SCALE));
    eval.aut(ctxts[i], temp, EXPONENT);
  }

  std::vector<SwitchingKey> swtKeys;
  client.genAutedModPackKeys(swtKeys, secKey, EXPONENT);

  Ciphertext ctxt;
  eval.modPack(ctxt, ctxts, swtKeys);

  Message dmsg(DEGREE);
  client.decrypt(dmsg, ctxt, secKey, std::pow(2.0, LOG_SCALE));

  for (u64 i = 0; i < DEGREE; ++i)
    std::cout << i << " " << dmsg[i] << std::endl;
}