#pragma once

#include <vector>

#include "Const.hpp"
#include "Polynomial.hpp"

namespace evd {
class MLWECiphertext {
public:
  MLWECiphertext(u64 rank) : rank_(rank), stack_(DEGREE / rank) {
    for (u64 i = 0; i < stack_; ++i)
      polys_.emplace_back(rank_, MOD_Q);
    polys_.emplace_back(rank_, MOD_Q);
  };

  Polynomial &getA(u64 idx) { return polys_[idx]; }
  Polynomial &getB() { return polys_[stack_]; }

  const Polynomial &getA(u64 idx) const { return polys_[idx]; }
  const Polynomial &getB() const { return polys_[stack_]; }

  u64 getRank() const { return rank_; }
  u64 getStack() const { return stack_; }
  u64 getDegree() const { return DEGREE; }

private:
  const u64 rank_;
  const u64 stack_;
  std::vector<Polynomial> polys_;
};
} // namespace evd