#pragma once

#include <vector>

#include "Const.hpp"
#include "Exception.hpp"
#include "Type.hpp"

namespace evd {
class Polynomial {
public:
  Polynomial(u64 degree, u64 mod)
      : data_(degree, 0UL), mod_(mod), is_ntt_(false) {
    if (mod_ == 0)
      throw InvalidNTTStateException();
  };

  u64 getDegree() const { return data_.size(); }
  u64 getMod() const { return mod_; };

  bool getIsNTT() const { return is_ntt_; };
  void setIsNTT(bool is_ntt) { is_ntt_ = is_ntt; };

  u64 *getData() { return data_.data(); };
  const u64 *getData() const { return data_.data(); };

  u64 &operator[](std::size_t idx) { return data_[idx]; };
  const u64 &operator[](std::size_t idx) const { return data_[idx]; };

private:
  std::vector<u64> data_;
  const u64 mod_;
  bool is_ntt_;
};
} // namespace evd