#pragma once

#include "Ciphertext.hpp"
#include "Const.hpp"
#include "HEval.hpp"
#include "MLWECiphertext.hpp"
#include "Polynomial.hpp"
#include "SwitchingKey.hpp"
#include "evd/MLWESwitchingKey.hpp"

namespace evd {

class Server {
public:
  Server(
      u64 logRank, const SwitchingKey &relinKey,
      const std::vector<std::vector<SwitchingKey>> &autedModPackKeys,
      const std::vector<std::vector<MLWESwitchingKey>> &autedModPackMLWEKeys);

  void cacheQuery(std::vector<Ciphertext> &res, const MLWECiphertext &query);
  void cacheQuery(std::vector<Polynomial> &res, const Polynomial &query);
  void cacheKeys(std::vector<Ciphertext> &res,
                 const std::vector<MLWECiphertext> &keys);
  void cacheKeys(std::vector<Polynomial> &res,
                 const std::vector<Polynomial> &keys);
  void innerProduct(Ciphertext &res, const std::vector<Ciphertext> &cachedQuery,
                    const std::vector<Ciphertext> &cachedKey);
  void innerProduct(Ciphertext &res, const std::vector<Ciphertext> &cachedQuery,
                    const std::vector<Polynomial> &cachedKey);

private:
  const u64 logRank_;
  const u64 rank_;
  const u64 stack_;

  HEval eval_;

  const SwitchingKey &relinKey_;
  const std::vector<std::vector<SwitchingKey>> &autedModPackKeys_;
  const std::vector<std::vector<MLWESwitchingKey>> &autedModPackMLWEKeys_;
};
} // namespace evd