OUTPUT_DIR=".output/lamp-1-prod"
mkdir -p $OUTPUT_DIR

find . | grep -E "(/pycache$|\.pyc$|\.pyo$)" | xargs rm -rf

# PubSys
sh scripts/lamp-1/infer_advanced_rag.sh lamp-1 time gpt-4o 0.0 4o > $OUTPUT_DIR/advanced_infer.4o.txt 2>&1

# DualSys
sh scripts/lamp-1/infer_cot_rag.sh lamp-1 time gpt-4o 0.0 llama3.2:1b 0.0 4o_1b > $OUTPUT_DIR/cot_infer.4o_1b.txt 2>&1
sh scripts/lamp-1/infer_graph_rag.sh lamp-1 time gpt-4o 0.0 llama3.2:1b 0.0 4o_1b > $OUTPUT_DIR/graph_infer.4o_1b.txt 2>&1

# PubSys (w/ separate reasoner)
sh scripts/lamp-1/infer_cot_rag.sh lamp-1 time gpt-4o 0.0 gpt-4o 0.0 4o_4o  > $OUTPUT_DIR/cot_infer.4o_4o.txt 2>&1
sh scripts/lamp-1/infer_graph_rag.sh lamp-1 time gpt-4o 0.0 gpt-4o 0.0 4o_4o  > $OUTPUT_DIR/graph_infer.4o_4o.txt 2>&1

# PriSys
sh scripts/lamp-1/infer_advanced_rag.sh lamp-1 time llama3.2:1b 0.0 1b > $OUTPUT_DIR/advanced_infer.1b.txt 2>&1

# PriSys (w/ separate reasoner)
sh scripts/lamp-1/infer_cot_rag.sh lamp-1 time llama3.2:1b 0.0 llama3.2:1b 0.0 1b_1b  > $OUTPUT_DIR/cot_infer.1b_1b.txt 2>&1
sh scripts/lamp-1/infer_graph_rag.sh lamp-1 time llama3.2:1b 0.0 llama3.2:1b 0.0 1b_1b  > $OUTPUT_DIR/graph_infer.1b_1b.txt 2>&1

# Eval
sh scripts/lamp-1/eval_advanced_rag.sh lamp-1 time 4o > $OUTPUT_DIR/advanced_eval.4o.txt 2>&1
sh scripts/lamp-1/eval_advanced_rag.sh lamp-1 time 1b > $OUTPUT_DIR/advanced_eval.1b.txt 2>&1
sh scripts/lamp-1/eval_cot_rag.sh lamp-1 time 4o_4o  > $OUTPUT_DIR/cot_eval.4o_4o.txt 2>&1
sh scripts/lamp-1/eval_cot_rag.sh lamp-1 time 4o_1b  > $OUTPUT_DIR/cot_eval.4o_1b.txt 2>&1
sh scripts/lamp-1/eval_cot_rag.sh lamp-1 time 1b_1b  > $OUTPUT_DIR/cot_eval.1b_1b.txt 2>&1
sh scripts/lamp-1/eval_graph_rag.sh lamp-1 time 4o_4o  > $OUTPUT_DIR/graph_eval.4o_4o.txt 2>&1
sh scripts/lamp-1/eval_graph_rag.sh lamp-1 time 4o_1b  > $OUTPUT_DIR/graph_eval.4o_1b.txt 2>&1
sh scripts/lamp-1/eval_graph_rag.sh lamp-1 time 1b_1b  > $OUTPUT_DIR/graph_eval.1b_1b.txt 2>&1
