OUTPUT_DIR=".output/locomo-prod"
mkdir -p $OUTPUT_DIR

find . | grep -E "(/pycache$|\.pyc$|\.pyo$)" | xargs rm -rf

# PubSys
sh scripts/locomo/infer_advanced_rag.sh locomo base gpt-4o 0.0 4o > $OUTPUT_DIR/advanced_infer.4o.txt 2>&1

# DualSys
sh scripts/locomo/infer_cot_rag.sh locomo base gpt-4o 0.0 llama3.2:1b 0.0 4o_1b > $OUTPUT_DIR/cot_infer.4o_1b.txt 2>&1
sh scripts/locomo/infer_graph_rag.sh locomo base gpt-4o 0.0 llama3.2:1b 0.0 4o_1b > $OUTPUT_DIR/graph_infer.4o_1b.txt 2>&1

# PubSys (w/ separate reasoner)
sh scripts/locomo/infer_cot_rag.sh locomo base gpt-4o 0.0 gpt-4o 0.0 4o_4o  > $OUTPUT_DIR/cot_infer.4o_4o.txt 2>&1
sh scripts/locomo/infer_graph_rag.sh locomo base gpt-4o 0.0 gpt-4o 0.0 4o_4o  > $OUTPUT_DIR/graph_infer.4o_4o.txt 2>&1

# PriSys
sh scripts/locomo/infer_advanced_rag.sh locomo base llama3.2:1b 0.0 1b > $OUTPUT_DIR/advanced_infer.1b.txt 2>&1

# PriSys (w/ separate reasoner)
sh scripts/locomo/infer_cot_rag.sh locomo base llama3.2:1b 0.0 llama3.2:1b 0.0 1b_1b  > $OUTPUT_DIR/cot_infer.1b_1b.txt 2>&1
sh scripts/locomo/infer_graph_rag.sh locomo base llama3.2:1b 0.0 llama3.2:1b 0.0 1b_1b  > $OUTPUT_DIR/graph_infer.1b_1b.txt 2>&1

# Eval
sh scripts/locomo/eval_advanced_rag.sh locomo base 4o > $OUTPUT_DIR/advanced_eval.4o.txt 2>&1
sh scripts/locomo/eval_advanced_rag.sh locomo base 1b > $OUTPUT_DIR/advanced_eval.1b.txt 2>&1
sh scripts/locomo/eval_cot_rag.sh locomo base 4o_4o  > $OUTPUT_DIR/cot_eval.4o_4o.txt 2>&1
sh scripts/locomo/eval_cot_rag.sh locomo base 4o_1b  > $OUTPUT_DIR/cot_eval.4o_1b.txt 2>&1
sh scripts/locomo/eval_cot_rag.sh locomo base 1b_1b  > $OUTPUT_DIR/cot_eval.1b_1b.txt 2>&1
sh scripts/locomo/eval_graph_rag.sh locomo base 4o_4o  > $OUTPUT_DIR/graph_eval.4o_4o.txt 2>&1
sh scripts/locomo/eval_graph_rag.sh locomo base 4o_1b  > $OUTPUT_DIR/graph_eval.4o_1b.txt 2>&1
sh scripts/locomo/eval_graph_rag.sh locomo base 1b_1b  > $OUTPUT_DIR/graph_eval.1b_1b.txt 2>&1
