set -ex

DATASET_NAME=${1:-mediq}
DATASET_VERSION=${2:-base}
GENERATOR_PRI_NAME=${3:-gpt-4o}
GENERATOR_PRI_TEMPERATURE=${4:-1.0}
EXPERIMENT_NAME=${5:-4o}

EXPERIMENT_DIR=".experiments/${DATASET_NAME}/${DATASET_VERSION}/${EXPERIMENT_NAME}"
mkdir -p $EXPERIMENT_DIR

OUTPUT_PATH="${EXPERIMENT_DIR}/inference_results_advanced_rag.json"
# . scripts/utils.sh
# confirm_output_path $OUTPUT_PATH

# FIXME this is MediQ specific
DEFAULT_DOCUMENT="The patient's status and previous experiences are listed as memories. Refer to these memories to identify the correct answer."

poetry run python src/infer.py \
    --rag_service_name="advanced" \
    --inference_results_path=$OUTPUT_PATH \
    --dataset_name="peliqan" \
    --qa_data_path=".db/${DATASET_NAME}/${DATASET_VERSION}/json_data/qa.json" \
    --document_data_path=".db/${DATASET_NAME}/${DATASET_VERSION}/json_data/document.json" \
    --retriever_name="dense" \
    --memory_db_uri=".db/${DATASET_NAME}/${DATASET_VERSION}/dense/memory_dragon_naive.db" \
    --embedding_fn_name="dragon" \
    --vector_db_name="naive" \
    --top_k=20 \
    --generator_pri_name="$GENERATOR_PRI_NAME" \
    --generator_pri_temperature="$GENERATOR_PRI_TEMPERATURE" \
    --generator_cache_dir=".cache/${DATASET_NAME}/${DATASET_VERSION}/generator_cache" \
    --infer_mode="both" \
    --num_workers=8 \
    --default_document="$DEFAULT_DOCUMENT"