set -ex

DATASET_NAME=${1:-peliqan}
DATASET_VERSION=${2:-poc_v0.3.0}

EXPERIMENT_NAME="dumb_baselines"

EXPERIMENT_DIR=".experiments/${DATASET_NAME}/${DATASET_VERSION}/${EXPERIMENT_NAME}"
mkdir -p $EXPERIMENT_DIR

OUTPUT_DIR="${EXPERIMENT_DIR}/dumb_baseline_inference_results.json"

poetry run python src/infer_dumb_baselines.py \
    --inference_results_dir=$OUTPUT_DIR \
    --dataset_name="peliqan" \
    --qa_data_path=".db/${DATASET_NAME}/${DATASET_VERSION}/json_data/qa.json"


for inference_result in $OUTPUT_DIR/*.json
do
    poetry run python src/eval.py \
        --inference_results_path=$inference_result \
        --evaluation_report_path=".experiments/${DATASET_NAME}/${DATASET_VERSION}/${EXPERIMENT_NAME}/evaluation_report.$(basename $inference_result)" \
        --infer_mode="both" \
        --num_workers=8
done
