DATASET_NAME=${1:-peliqan}
DATASET_VERSION=${2:-poc_v0.3.0}

EXPERIMENT_DIR=".experiments/${DATASET_NAME}/${DATASET_VERSION}"
mkdir -p $EXPERIMENT_DIR

OUTPUT_PATH="${EXPERIMENT_DIR}/inference_results_naive_rag.json"
source scripts/utils.sh
confirm_output_path $OUTPUT_PATH

poetry run python src/infer.py \
    --rag_service_name="naive" \
    --inference_results_path=$OUTPUT_PATH \
    --dataset_name="peliqan" \
    --qa_data_path=".db/${DATASET_NAME}/${DATASET_VERSION}/json_data/qa.json" \
    --document_data_path=".db/${DATASET_NAME}/${DATASET_VERSION}/json_data/document.json" \
    --retriever_name="dense" \
    --memory_db_uri=".db/${DATASET_NAME}/${DATASET_VERSION}/dense/memory_dragon_naive_COSINE.db" \
    --embedding_fn_name="dragon" \
    --vector_db_name="naive" \
    --top_k=5 \
    --generator_pri_name="gpt-4o-mini" \
    --infer_mode="both" \
    --num_workers=8 \
    --use_answer_separation=0
