### Common
find . | grep -E "(/pycache$|\.pyc$|\.pyo$)" | xargs rm -rf

LLAMA_1B="accounts/fireworks/models/llama-v3p2-1b-instruct#accounts/anonymized"
LLAMA_3B="accounts/fireworks/models/llama-v3p2-3b-instruct#accounts/anonymized"
LLAMA_8B="accounts/fireworks/models/llama-v3p1-8b-instruct#accounts/anonymized"

GEMINI="gemini-1.5-pro"

### LoCoMo

OUTPUT_DIR=".output/locomo-prod"
mkdir -p $OUTPUT_DIR

# PubSys
sh scripts/locomo/infer_advanced_rag.sh locomo base gpt-4o 0.0 4o > $OUTPUT_DIR/advanced_infer.4o.txt 2>&1
sh scripts/locomo/eval_advanced_rag.sh locomo base 4o > $OUTPUT_DIR/advanced_eval.4o.txt 2>&1

sh scripts/locomo/infer_advanced_rag.sh locomo base $GEMINI 0.0 gemini > $OUTPUT_DIR/advanced_infer.gemini.txt 2>&1
sh scripts/locomo/eval_advanced_rag.sh locomo base gemini > $OUTPUT_DIR/advanced_eval.gemini.txt 2>&1

# PriSys
sh scripts/locomo/infer_advanced_rag.sh locomo base $LLAMA_1B 0.0 1b > $OUTPUT_DIR/advanced_infer.1b.txt 2>&1
sh scripts/locomo/eval_advanced_rag.sh locomo base 1b > $OUTPUT_DIR/advanced_eval.1b.txt 2>&1

sh scripts/locomo/infer_advanced_rag.sh locomo base $LLAMA_3B 0.0 3b > $OUTPUT_DIR/advanced_infer.3b.txt 2>&1
sh scripts/locomo/eval_advanced_rag.sh locomo base 3b > $OUTPUT_DIR/advanced_eval.3b.txt 2>&1

# DualSys
sh scripts/locomo/infer_cot_rag.sh locomo base gpt-4o 0.0 $LLAMA_1B 0.0 4o_1b > $OUTPUT_DIR/cot_infer.4o_1b.txt 2>&1
sh scripts/locomo/eval_cot_rag.sh locomo base 4o_1b  > $OUTPUT_DIR/cot_eval.4o_1b.txt 2>&1

sh scripts/locomo/infer_cot_rag.sh locomo base $GEMINI 0.0 $LLAMA_1B 0.0 gemini_1b > $OUTPUT_DIR/cot_infer.gemini_1b.txt 2>&1
sh scripts/locomo/eval_cot_rag.sh locomo base gemini_1b  > $OUTPUT_DIR/cot_eval.gemini_1b.txt 2>&1

sh scripts/locomo/infer_cot_rag.sh locomo base gpt-4o 0.0 $LLAMA_3B 0.0 4o_3b > $OUTPUT_DIR/cot_infer.4o_3b.txt 2>&1
sh scripts/locomo/eval_cot_rag.sh locomo base 4o_3b  > $OUTPUT_DIR/cot_eval.4o_3b.txt 2>&1

sh scripts/locomo/infer_cot_rag.sh locomo base $GEMINI 0.0 $LLAMA_3B 0.0 gemini_3b > $OUTPUT_DIR/cot_infer.gemini_3b.txt 2>&1
sh scripts/locomo/eval_cot_rag.sh locomo base gemini_3b  > $OUTPUT_DIR/cot_eval.gemini_3b.txt 2>&1

# Ablation
sh scripts/locomo/infer_cot_rag.sh locomo base gpt-4o 0.0 gpt-4o 0.0 4o_4o > $OUTPUT_DIR/cot_infer.4o_4o.txt 2>&1
sh scripts/locomo/eval_cot_rag.sh locomo base 4o_4o  > $OUTPUT_DIR/cot_eval.4o_4o.txt 2>&1

sh scripts/locomo/infer_cot_rag.sh locomo base $LLAMA_1B 0.0 $LLAMA_1B 0.0 1b_1b > $OUTPUT_DIR/cot_infer.1b_1b.txt 2>&1
sh scripts/locomo/eval_cot_rag.sh locomo base 1b_1b  > $OUTPUT_DIR/cot_eval.1b_1b.txt 2>&1

# S1 + L1 + S1
sh scripts/locomo/infer_cot_rag.sh locomo base gpt-4o 0.0 $LLAMA_1B 0.0 1b_4o_1b $LLAMA_1B 0.0 > $OUTPUT_DIR/cot_infer.1b_4o_1b.txt 2>&1
sh scripts/locomo/eval_cot_rag.sh locomo base 1b_4o_1b  > $OUTPUT_DIR/cot_eval.1b_4o_1b.txt 2>&1
# GT + L1 + S1
sh scripts/locomo/infer_cot_with_gt_retrieval.sh locomo base gpt-4o 0.0 $LLAMA_1B 0.0 gt_4o_1b > $OUTPUT_DIR/cot_infer.gt_4o_1b.txt 2>&1
sh scripts/locomo/eval_cot_with_gt_retrieval.sh locomo base gt_4o_1b  > $OUTPUT_DIR/cot_eval.gt_4o_1b.txt 2>&1
# L1 + N/A + S1
sh scripts/locomo/infer_advanced_rag.sh locomo base $LLAMA_1B 0.0 4o__1b gpt-4o 0.0 > $OUTPUT_DIR/advanced_infer.4o__1b.txt 2>&1
sh scripts/locomo/eval_advanced_rag.sh locomo base 4o__1b > $OUTPUT_DIR/advanced_eval.4o__1b.txt 2>&1
# L1 + S1 + S1
sh scripts/locomo/infer_cot_rag.sh locomo base $LLAMA_1B 0.0 $LLAMA_1B 0.0 4o_1b_1b gpt-4o 0.0 > $OUTPUT_DIR/cot_infer.4o_1b_1b.txt 2>&1
sh scripts/locomo/eval_cot_rag.sh locomo base 4o_1b_1b  > $OUTPUT_DIR/cot_eval.4o_1b_1b.txt 2>&1

# GT + S1 + S1
sh scripts/locomo/infer_cot_with_gt_retrieval.sh locomo base $LLAMA_1B 0.0 $LLAMA_1B 0.0 gt_1b_1b > $OUTPUT_DIR/cot_infer.gt_1b_1b.txt 2>&1
sh scripts/locomo/eval_cot_with_gt_retrieval.sh locomo base gt_1b_1b  > $OUTPUT_DIR/cot_eval.gt_1b_1b.txt 2>&1
# S1 + N/A + S1
sh scripts/locomo/infer_advanced_rag.sh locomo base $LLAMA_1B 0.0 1b__1b $LLAMA_1B 0.0 > $OUTPUT_DIR/advanced_infer.1b__1b.txt 2>&1
sh scripts/locomo/eval_advanced_rag.sh locomo base 1b__1b > $OUTPUT_DIR/advanced_eval.1b__1b.txt 2>&1


### MediQ

OUTPUT_DIR=".output/mediq-prod-top20"
mkdir -p $OUTPUT_DIR

# PubSys
sh scripts/mediq/infer_advanced_rag.sh mediq base gpt-4o 0.0 4o > $OUTPUT_DIR/advanced_infer.4o.txt 2>&1
sh scripts/mediq/eval_advanced_rag.sh mediq base 4o > $OUTPUT_DIR/advanced_eval.4o.txt 2>&1

sh scripts/mediq/infer_advanced_rag.sh mediq base $GEMINI 0.0 gemini > $OUTPUT_DIR/advanced_infer.gemini.txt 2>&1
sh scripts/mediq/eval_advanced_rag.sh mediq base gemini > $OUTPUT_DIR/advanced_eval.gemini.txt 2>&1

# PriSys
sh scripts/mediq/infer_advanced_rag.sh mediq base $LLAMA_1B 0.0 1b > $OUTPUT_DIR/advanced_infer.1b.txt 2>&1
sh scripts/mediq/eval_advanced_rag.sh mediq base 1b > $OUTPUT_DIR/advanced_eval.1b.txt 2>&1

sh scripts/mediq/infer_advanced_rag.sh mediq base $LLAMA_3B 0.0 3b > $OUTPUT_DIR/advanced_infer.3b.txt 2>&1
sh scripts/mediq/eval_advanced_rag.sh mediq base 3b > $OUTPUT_DIR/advanced_eval.3b.txt 2>&1

# DualSys
sh scripts/mediq/infer_cot_rag.sh mediq base gpt-4o 0.0 $LLAMA_1B 0.0 4o_1b > $OUTPUT_DIR/cot_infer.4o_1b.txt 2>&1
sh scripts/mediq/eval_cot_rag.sh mediq base 4o_1b  > $OUTPUT_DIR/cot_eval.4o_1b.txt 2>&1

sh scripts/mediq/infer_cot_rag.sh mediq base $GEMINI 0.0 $LLAMA_1B 0.0 gemini_1b > $OUTPUT_DIR/cot_infer.gemini_1b.txt 2>&1
sh scripts/mediq/eval_cot_rag.sh mediq base gemini_1b  > $OUTPUT_DIR/cot_eval.gemini_1b.txt 2>&1

sh scripts/mediq/infer_cot_rag.sh mediq base gpt-4o 0.0 $LLAMA_3B 0.0 4o_3b > $OUTPUT_DIR/cot_infer.4o_3b.txt 2>&1
sh scripts/mediq/eval_cot_rag.sh mediq base 4o_3b  > $OUTPUT_DIR/cot_eval.4o_3b.txt 2>&1

sh scripts/mediq/infer_cot_rag.sh mediq base $GEMINI 0.0 $LLAMA_3B 0.0 gemini_3b > $OUTPUT_DIR/cot_infer.gemini_3b.txt 2>&1
sh scripts/mediq/eval_cot_rag.sh mediq base gemini_3b  > $OUTPUT_DIR/cot_eval.gemini_3b.txt 2>&1


### LaMP

OUTPUT_DIR=".output/lamp-1-prod"
mkdir -p $OUTPUT_DIR

# PubSys
sh scripts/lamp-1/infer_advanced_rag.sh lamp-1 time gpt-4o 0.0 4o > $OUTPUT_DIR/advanced_infer.4o.txt 2>&1
sh scripts/lamp-1/eval_advanced_rag.sh lamp-1 time 4o > $OUTPUT_DIR/advanced_eval.4o.txt 2>&1

sh scripts/lamp-1/infer_advanced_rag.sh lamp-1 time $GEMINI 0.0 gemini > $OUTPUT_DIR/advanced_infer.gemini.txt 2>&1
sh scripts/lamp-1/eval_advanced_rag.sh lamp-1 time gemini > $OUTPUT_DIR/advanced_eval.gemini.txt 2>&1

# PriSys
sh scripts/lamp-1/infer_advanced_rag.sh lamp-1 time $LLAMA_1B 0.0 1b > $OUTPUT_DIR/advanced_infer.1b.txt 2>&1
sh scripts/lamp-1/eval_advanced_rag.sh lamp-1 time 1b > $OUTPUT_DIR/advanced_eval.1b.txt 2>&1

sh scripts/lamp-1/infer_advanced_rag.sh lamp-1 time $LLAMA_3B 0.0 3b > $OUTPUT_DIR/advanced_infer.3b.txt 2>&1
sh scripts/lamp-1/eval_advanced_rag.sh lamp-1 time 3b > $OUTPUT_DIR/advanced_eval.3b.txt 2>&1

# DualSys
sh scripts/lamp-1/infer_cot_rag.sh lamp-1 time gpt-4o 0.0 $LLAMA_1B 0.0 4o_1b > $OUTPUT_DIR/cot_infer.4o_1b.txt 2>&1
sh scripts/lamp-1/eval_cot_rag.sh lamp-1 time 4o_1b  > $OUTPUT_DIR/cot_eval.4o_1b.txt 2>&1

sh scripts/lamp-1/infer_cot_rag.sh lamp-1 time $GEMINI 0.0 $LLAMA_1B 0.0 gemini_1b > $OUTPUT_DIR/cot_infer.gemini_1b.txt 2>&1
sh scripts/lamp-1/eval_cot_rag.sh lamp-1 time gemini_1b  > $OUTPUT_DIR/cot_eval.gemini_1b.txt 2>&1

sh scripts/lamp-1/infer_cot_rag.sh lamp-1 time gpt-4o 0.0 $LLAMA_3B 0.0 4o_3b > $OUTPUT_DIR/cot_infer.4o_3b.txt 2>&1
sh scripts/lamp-1/eval_cot_rag.sh lamp-1 time 4o_3b  > $OUTPUT_DIR/cot_eval.4o_3b.txt 2>&1

sh scripts/lamp-1/infer_cot_rag.sh lamp-1 time $GEMINI 0.0 $LLAMA_3B 0.0 gemini_3b > $OUTPUT_DIR/cot_infer.gemini_3b.txt 2>&1
sh scripts/lamp-1/eval_cot_rag.sh lamp-1 time gemini_3b  > $OUTPUT_DIR/cot_eval.gemini_3b.txt 2>&1
