### Common
find . | grep -E "(/pycache$|\.pyc$|\.pyo$)" | xargs rm -rf

LLAMA_1B="accounts/fireworks/models/llama-v3p2-1b-instruct#accounts/anonymized"
LLAMA_3B="accounts/fireworks/models/llama-v3p2-3b-instruct#accounts/anonymized"
LLAMA_8B="accounts/fireworks/models/llama-v3p1-8b-instruct#accounts/anonymized"

GEMINI="gemini-1.5-pro"
CLAUDE="claude-3-5-sonnet-20241022"

### LoCoMo

OUTPUT_DIR=".output/locomo-prod"
mkdir -p $OUTPUT_DIR

# PubSys
sh scripts/locomo/infer_advanced_rag.sh locomo base $CLAUDE 0.0 claude > $OUTPUT_DIR/advanced_infer.claude.txt 2>&1
sh scripts/locomo/eval_advanced_rag.sh locomo base claude > $OUTPUT_DIR/advanced_eval.claude.txt 2>&1

# PriSys
sh scripts/locomo/infer_advanced_rag.sh locomo base $LLAMA_8B 0.0 8b > $OUTPUT_DIR/advanced_infer.8b.txt 2>&1
sh scripts/locomo/eval_advanced_rag.sh locomo base 8b > $OUTPUT_DIR/advanced_eval.8b.txt 2>&1

# DualSys (S1)
sh scripts/locomo/infer_cot_rag.sh locomo base $CLAUDE 0.0 $LLAMA_1B 0.0 claude_1b > $OUTPUT_DIR/cot_infer.claude_1b.txt 2>&1
sh scripts/locomo/eval_cot_rag.sh locomo base claude_1b  > $OUTPUT_DIR/cot_eval.claude_1b.txt 2>&1

# DualSys (S2)
sh scripts/locomo/infer_cot_rag.sh locomo base $CLAUDE 0.0 $LLAMA_3B 0.0 claude_3b > $OUTPUT_DIR/cot_infer.claude_3b.txt 2>&1
sh scripts/locomo/eval_cot_rag.sh locomo base claude_3b  > $OUTPUT_DIR/cot_eval.claude_3b.txt 2>&1

# DualSys (S3)
sh scripts/locomo/infer_cot_rag.sh locomo base gpt-4o 0.0 $LLAMA_8B 0.0 4o_8b > $OUTPUT_DIR/cot_infer.4o_8b.txt 2>&1
sh scripts/locomo/eval_cot_rag.sh locomo base 4o_8b  > $OUTPUT_DIR/cot_eval.4o_8b.txt 2>&1

sh scripts/locomo/infer_cot_rag.sh locomo base $GEMINI 0.0 $LLAMA_8B 0.0 gemini_8b > $OUTPUT_DIR/cot_infer.gemini_8b.txt 2>&1
sh scripts/locomo/eval_cot_rag.sh locomo base gemini_8b  > $OUTPUT_DIR/cot_eval.gemini_8b.txt 2>&1

sh scripts/locomo/infer_cot_rag.sh locomo base $CLAUDE 0.0 $LLAMA_8B 0.0 claude_8b > $OUTPUT_DIR/cot_infer.claude_8b.txt 2>&1
sh scripts/locomo/eval_cot_rag.sh locomo base claude_8b  > $OUTPUT_DIR/cot_eval.claude_8b.txt 2>&1

### MediQ

OUTPUT_DIR=".output/mediq-prod"
mkdir -p $OUTPUT_DIR

# PubSys
sh scripts/mediq/infer_advanced_rag.sh mediq base $CLAUDE 0.0 claude > $OUTPUT_DIR/advanced_infer.claude.txt 2>&1
sh scripts/mediq/eval_advanced_rag.sh mediq base claude > $OUTPUT_DIR/advanced_eval.claude.txt 2>&1

# PriSys
sh scripts/mediq/infer_advanced_rag.sh mediq base $LLAMA_8B 0.0 8b > $OUTPUT_DIR/advanced_infer.8b.txt 2>&1
sh scripts/mediq/eval_advanced_rag.sh mediq base 8b > $OUTPUT_DIR/advanced_eval.8b.txt 2>&1

# DualSys (S1)
sh scripts/mediq/infer_cot_rag.sh mediq base $CLAUDE 0.0 $LLAMA_1B 0.0 claude_1b > $OUTPUT_DIR/cot_infer.claude_1b.txt 2>&1
sh scripts/mediq/eval_cot_rag.sh mediq base claude_1b  > $OUTPUT_DIR/cot_eval.claude_1b.txt 2>&1

# DualSys (S2)
sh scripts/mediq/infer_cot_rag.sh mediq base $CLAUDE 0.0 $LLAMA_3B 0.0 claude_3b > $OUTPUT_DIR/cot_infer.claude_3b.txt 2>&1
sh scripts/mediq/eval_cot_rag.sh mediq base claude_3b  > $OUTPUT_DIR/cot_eval.claude_3b.txt 2>&1

# DualSys (S3)
sh scripts/mediq/infer_cot_rag.sh mediq base gpt-4o 0.0 $LLAMA_8B 0.0 4o_8b > $OUTPUT_DIR/cot_infer.4o_8b.txt 2>&1
sh scripts/mediq/eval_cot_rag.sh mediq base 4o_8b  > $OUTPUT_DIR/cot_eval.4o_8b.txt 2>&1

sh scripts/mediq/infer_cot_rag.sh mediq base $GEMINI 0.0 $LLAMA_8B 0.0 gemini_8b > $OUTPUT_DIR/cot_infer.gemini_8b.txt 2>&1
sh scripts/mediq/eval_cot_rag.sh mediq base gemini_8b  > $OUTPUT_DIR/cot_eval.gemini_8b.txt 2>&1

sh scripts/mediq/infer_cot_rag.sh mediq base $CLAUDE 0.0 $LLAMA_8B 0.0 claude_8b > $OUTPUT_DIR/cot_infer.claude_8b.txt 2>&1
sh scripts/mediq/eval_cot_rag.sh mediq base claude_8b  > $OUTPUT_DIR/cot_eval.claude_8b.txt 2>&1
