from torch.utils.data import (
    DataLoader,
    Dataset,
)


class BaseDataset(Dataset):
    def get_data_loader(
        self,
        batch_size: int,
        shuffle: bool = False,
        num_workers: int = 8,
    ) -> DataLoader:
        return DataLoader(
            self,
            batch_size=batch_size,
            shuffle=shuffle,
            num_workers=num_workers,
        )
