from src.dataset.base_dataset import BaseDataset
from src.schema import QA
from src.utils.json import read_json_file


class PELIQANDataset(BaseDataset):
    def __init__(self, qa_data_path: str) -> None:
        super().__init__()
        qa_data_dict = read_json_file(qa_data_path)
        self.qa_data = [QA(**qa) for qa in qa_data_dict]

    def __len__(self) -> int:
        return len(self.qa_data)

    def __getitem__(self, idx: int) -> QA:
        return self.qa_data[idx]
