from abc import (
    ABC,
    abstractmethod,
)

from src.schema import InferenceResult


class BaseMetric(ABC):
    @abstractmethod
    def __init__(self) -> None:
        raise NotImplementedError()

    @abstractmethod
    def reset(self) -> None:
        raise NotImplementedError()

    @abstractmethod
    def update(self, res: InferenceResult) -> None:
        raise NotImplementedError()

    @abstractmethod
    def compute(self) -> float:
        raise NotImplementedError()
