from abc import (
    ABC,
    abstractmethod,
)
from pathlib import Path
from typing import (
    Any,
    Callable,
    Dict,
    Generator,
    Optional,
)

from src.service.query_cache_service import QueryCacheService


class BaseGenerator(ABC):
    @abstractmethod
    def __init__(self, model_name: str, temperature: float) -> None:
        raise NotImplementedError()

    @abstractmethod
    def generate(self, prompt: str, json_mode: bool = False, json_schema: Optional[Dict[str, Any]] = None) -> str:
        raise NotImplementedError()

    @abstractmethod
    def generate_async(self, prompt: str, json_mode: bool = False) -> Generator[str, None, None]:
        raise NotImplementedError()

    @property
    def identifier(self):
        return f"{self.__class__.__name__}--{self.model_name}--temperature={self.temperature}"
