import os
from pathlib import Path

from loguru import logger


cache_root = Path(".cache")

count, deleted_count = 0, 0

for value_path in cache_root.glob("**/*.value.txt"):
    should_delete = False
    with value_path.open() as f:
        if not f.read().strip():
            should_delete = True
    
    if should_delete:
        os.remove(value_path)
        query_path = value_path.parent / value_path.name.replace(".value.txt", ".query.txt")
        os.remove(query_path)

        deleted_count += 1

    count += 1

logger.info(f"Scanned: {count} Deleted: {deleted_count}")
