from abc import (
    ABC,
    abstractmethod,
)
from typing import (
    List,
    Tuple,
)


class BaseRetriever(ABC):
    @abstractmethod
    def __init__(self) -> None:
        raise NotImplementedError()

    @abstractmethod
    def retrieve(self, collection_name: str, query: str) -> Tuple[List[str], List[str], List[float]]:
        raise NotImplementedError()
