## Data Schema

### document.json

```json
[
  {
    "document_id": "{document_id}",
    "title": "{title}",
    "content": "{content}",
    "source": "{source}"
  },
]
```

### memory.json

```json
[
  {
    "user_id": "{user_id}",
    "memories": [
      {
        "memory_id": "{memory_i}",
        "content": "{content}",
      },
    ]
  },
]
```

### qa.json

```json
[
  {
    "question_id": "{question_id}",
    "question": "{question}",
    "document_ids": [
      "{document_id}",
    ],
    "sub_questions": [
      "{sub_question}",
    ],
    "related_user_ids": [
      "{related_user_id}",
    ],
    "answer_sets": [
      {
        "answer_set_id": "{answer_set_id}",
        "user_id": "{user_id}",
        "elements": [
          "{element}"
        ],
        "ref_memory_ids": [
          "{ref_memory_id}",
        ],
        "ref_memory_contents": [
          "{ref_memory_content}",
        ]
      },
    ],
    "metadata": {
      "{something}": "{something}"
    }
  },
]
```

## Example

### document.json

```json
[
  {
    "document_id": "D66",
    "title": "https://www.gov.uk/apply-gender-recognition-certificate",
    "content": "Apply for a Gender Recognition Certificate\n<h1>Overview</h1>\n<p>Apply to the Gender Recognition Panel for a Gender Recognition Certificate if you want your acquired gender to be legally recognised in the UK.</p>...",
    "source": "conditionalQA"
  },
]
```

### memory.json

```json
[
  {
    "user_id": "U0",
    "memories": [
      {
        "memory_id": "M76",
        "content": "Did your spouse fill in a statutory declaration?\nspouse did not fill in declaration"
      },
      {
        "memory_id": "M232",
        "content": "Do you and your spouse agree to stay married?\ndo not agree to stay married"
      },
    ]
  },
  {
    "user_id": "U1",
    "memories": [
      {
        "memory_id": "M506",
        "content": "Did your spouse fill in a statutory declaration?\nspouse filled in declaration"
      },
      {
        "memory_id": "M702",
        "content": "Do you and your spouse agree to stay married?\nboth agree to stay married"
      },
    ]
  },
]
```

### qa.json

```json
[
  {
    "question_id": "Q7",
    "question": "I married my wife 10 years ago. I now want to legally change my gender and I am applying for a Gender Recognition Certificate.\nWill my marriage's legal status change?",
    "document_ids": ["D66"],
    "sub_questions": [
      "Do you and your spouse agree to stay married?",
      "Did your spouse fill in a statutory declaration?"
    ],
    "related_user_ids": ["U0", "U1"],
    "answer_sets": [
      {
        "answer_set_id": "A14",
        "user_id": "U0",
        "elements": ["yes"],
        "ref_memory_ids": ["M232", "M76"],
        "ref_memory_contents": [
          "Do you and your spouse agree to stay married?\ndo not agree to stay married",
          "Did your spouse fill in a statutory declaration?\nspouse did not fill in declaration"
        ]
      },
      {
        "answer_set_id": "A15",
        "user_id": "U1",
        "elements": ["no"],
        "ref_memory_ids": ["M702", "M506"],
        "ref_memory_contents": [
          "Do you and your spouse agree to stay married?\nboth agree to stay married",
          "Did your spouse fill in a statutory declaration?\nspouse filled in declaration"
        ]
      }
    ],
    "metadata": null
  }
]
```