from typing import (
    Dict,
    List,
    Optional,
    Set,
)

from pydantic import BaseModel


class AnswerSet(BaseModel):
    answer_set_id: str
    user_id: str
    elements: Set[str]
    ref_memory_ids: List[str]
    ref_memory_contents: List[str]
    metadata: Optional[Dict] = None


class QA(BaseModel):
    question_id: str
    question: str
    document_ids: List[str]
    sub_questions: List[str]
    related_user_ids: List[str]
    answer_sets: List[AnswerSet]
    answer_element_universe: Optional[List[str]] = None
