from typing import (
    List,
    Optional,
)

from pydantic import BaseModel


class ReasoningEdge(BaseModel):
    edge_id: int
    src_node_id: int
    dst_node_id: int
    condition: str


class ReasoningNode(BaseModel):
    node_id: int
    is_root: bool
    is_leaf: bool
    sub_query: Optional[str]
    answer: Optional[str]
    edges: List[ReasoningEdge]


class ReasoningGraph(BaseModel):
    nodes: List[ReasoningNode]