from typing import (
    Dict,
    List,
    Optional,
    Set,
)

from pydantic import BaseModel

from src.schema.qa import QA


class PredictedAnswerSet(BaseModel):
    answer_set_id: str
    user_id: str
    raw_answer: Optional[str] = None
    elements: Optional[Set[str]] = None
    ref_memory_ids: List[str]
    ref_memory_contents: List[str]
    ref_memory_scores: Optional[List[float]] = None
    meta_data: Optional[Dict] = None


class InferenceResult(BaseModel):
    qa: QA
    pred_answer_sets: List[PredictedAnswerSet]


class GPSReport(BaseModel):
    gps: float
    gps_u: float


class EvaluationReport(BaseModel):
    recall_at_k: float
    em: float
    f1: float
    ips: float
    gps: GPSReport
