from typing import List

from src.schema import Document
from src.utils.json import read_json_file


class DocumentService:
    def __init__(self, document_data_path: str) -> None:
        documents_dict = read_json_file(document_data_path)
        documents = [Document(**document) for document in documents_dict]
        self.document_map = {doc.document_id: doc for doc in documents}

    def get_documents(self, document_ids: List[str]) -> List[Document]:
        documents = [self.document_map[doc_id] for doc_id in document_ids]
        return documents
