from abc import (
    ABC,
    abstractmethod,
)
from typing import (
    List,
    Optional,
    Tuple,
)

from src.schema import Document


class BaseRAGService(ABC):
    @abstractmethod
    def retrieve(
        self,
        collection_name: str,
        query: str,
        documents: List[Document],
    ) -> Tuple[List[str], List[str], List[float]]:
        raise NotImplementedError

    @abstractmethod
    def generate(
        self,
        query: str,
        documents: List[Document],
        ret_memory_contents: List[str],
    ) -> str:
        raise NotImplementedError

    @abstractmethod
    def forward(
        self,
        collection_name: str,
        query: str,
        documents: List[Document],
        answer_element_universe: Optional[List[str]],
    ) -> Tuple[str, List[str], List[str], List[float]]:
        raise NotImplementedError
