from typing import (
    List,
    TypeVar,
)


T = TypeVar("T")


def batched(arr: T, batch_size: int) -> List[T]:
    return [arr[start : start + batch_size] for start in range(0, len(arr), batch_size)]
