import json

from typing import (
    Dict,
    List,
    Union,
)


def read_json_file(file_path: str) -> Union[List, Dict]:
    with open(file_path, "r") as f:
        return json.load(f)


def write_json_file(file_path: str, data: Union[List, Dict]) -> None:
    with open(file_path, "w") as f:
        json.dump(data, f, indent=4)
