import os
import sys
import traceback

from loguru import logger


VALID_LOG_LEVELS = [
    "TRACE",
    "DEBUG",
    "INFO",
    "SUCCESS",
    "WARNING",
    "ERROR",
    "CRITICAL",
]


def set_log_level():
    log_level = os.getenv("LOG_LEVEL", "INFO").upper()

    if log_level not in VALID_LOG_LEVELS:
        raise ValueError(f"Invalid log level: {log_level}")

    logger.remove()
    logger.add(sys.stderr, level=log_level)


def log_exception_in_retry(retry_state):
    exception = retry_state.outcome.exception()
    if exception:
        trace = "".join(traceback.format_exception(type(exception), exception, exception.__traceback__))
        logger.error(f"Retrying after exception: {exception}. Traceback: {trace}")
