from typing import (
    List,
    Set,
)


FULL_SET_ELEMENT = "FULL_SET"


def iou(set1: Set, set2: Set) -> float:
    if not set1 and not set2:
        return 1.0
    return len(set1.intersection(set2)) / len(set1.union(set2))


def intersection(set1: Set, set2: Set) -> Set:
    return set.intersection(set1, set2)


def intersection_of_sets(sets: List[Set]) -> Set:
    if not sets:
        return set()
    return set.intersection(*sets)


def union(set1: Set, set2: Set) -> Set:
    return set.union(set1, set2)


def union_of_sets(sets: List[Set]) -> Set:
    if not sets:
        return set()
    return set.union(*sets)
