from abc import (
    ABC,
    abstractmethod,
)
from typing import (
    Any,
    List,
)

from nptyping import (
    Float32,
    NDArray,
)


class BaseEmbeddingFunction(ABC):
    @abstractmethod
    def __init__(self) -> None:
        raise NotImplementedError()

    @abstractmethod
    def embed_documents(self, documents: List[str]) -> NDArray[Any, Float32]:
        raise NotImplementedError()

    @abstractmethod
    def embed_queries(self, queries: List[str]) -> NDArray[Any, Float32]:
        raise NotImplementedError()

    @property
    @abstractmethod
    def dim(self) -> int:
        raise NotImplementedError()

    @property
    @abstractmethod
    def metric_type(self) -> str:
        raise NotImplementedError()

