# MoEDM (Also Called DPDM)
## Our code is based on [Guided Diffusion](https://github.com/openai/guided-diffusion) and [Latent Diffusion](https://github.com/compvis/latent-diffusion)

## Prepare the environment
First install torch from its [official website](https://pytorch.org).

Then run :
```
# For Guided Diffusion
pip install opencv-python rich blobfile tqdm prettytable clean-fid wandb gdown
conda install mpi4py

# For Latent Diffusion
git clone ​https://github.com/CompVis/taming-transformers
pip install -e ./taming-transformers
pip install omegaconf>=2.0.0 pytorch-lightning==1.0.8
pip install torch-fidelity einops clip kornia opencv-python albumentations academictorrents test-tube wandb
```

## Running
First down load our checkpoints as:
```
gdown ​https://drive.google.com/file/d/1NZ1yY-zqDgo-htF4MO2t2n5Md3B_eahS/view?usp=sharing
```
Then refer to "dpdm/static/README.md", "dpdm/dpdm/README.md" and "dpdm/LDM/README.md" for detailed commands.

"dpdm/static" demonstrates how we score the parameters in diffusion models, and "dpdm/dpdm" demonstrates DPDM based on Guided Diffusion, and "dpdm/LDM" demonstrates DPDM based on Latent Diffusion
