# Static Lightweight Diffusion Models
## Our code is based on [Guided Diffusion](https://github.com/openai/guided-diffusion)



## Download pre-trained models and relevant files
The diffusion model checkpoints we use is released by [Guided Diffusion](http://arxiv.org/abs/2105.05233). You can download them here:

 * 256x256 classifier: [256x256_classifier.pt](https://openaipublic.blob.core.windows.net/diffusion/jul-2021/256x256_classifier.pt)
 * 256x256 diffusion: [256x256_diffusion.pt](https://openaipublic.blob.core.windows.net/diffusion/jul-2021/256x256_diffusion.pt)


<font color= "#FF0000"> The all files (including check points in nips2023.zip) mentioned above should be saved at "scripts/models/".</font> <br />

(We provide ready score lists and a check point of size 35%.)

## Prune the model
Run the following command to prune the model. You can choose the channel pruning scale by setting the "--pruning_scale" in prune.sh. This script will save a pruned model and a info file which is important for rebuilding the pruned model.
```
cd scripts
bash prune.sh
```

After pruning the model, you can directly sample some images by running the following command. Remember to set the "--save_path" in sample_pruned_model.sh. You should make sure the pruned model's size match with the info file saved by prune.sh
```
cd scripts
bash sample_pruned_model.sh
```

If you want to compute FID for images of a specific imagenet label, run the following command. Remember to set fdir1 and fdir2 in 'fid.py', one of them should be the dataset path of the specific imagenet label. For example, the dataset for label 207 in imagenet is 'imagenet/train/n02099601'.
```
cd scripts
python fid.py
```
