from pygments.lexers import JuliaLexer
from pygments.token import Name, Generic

class EPTLexer(JuliaLexer):
    name = 'EPT'
    aliases = ['ept']
    filenames = ['*.jl'] # just to have one if you whant to use
    
    EXTRA_KEYWORDS = ['estimate_expectation', 'TABI', 'TuringAlgorithm', 'AnIS']
    
    def get_tokens_unprocessed(self, text):
        for index, token, value in JuliaLexer.get_tokens_unprocessed(self, text):
            if token is Name and value in self.EXTRA_KEYWORDS:
                yield index, Generic.Emph, value
            else:
                yield index, token, value
