from types import SimpleNamespace

from scripts.runner.evolve import DAREConfig, TiesConfig
from scripts.utils.pure import MiniCPMConfig

n_trials = 100

data = "select500_1"
target = "ja_select500"
extract_target = "findings"

num_data = 100

dataset = "simple"

fp16 = True

base_model_name = "meta-llama/Meta-Llama-3-8B"

question = (
    "あなたは優秀な放射線科医です。このレントゲン写真を見て、所見文を書いてください。"
)
vlm = SimpleNamespace(
    name="openbmb/MiniCPM-Llama3-V-2_5",
    minicpm=MiniCPMConfig(
        msgs=[{"role": "user", "content": question}],
        sampling=False,
        temperature=0.7,
        system_prompt="",
        max_new_tokens=128,
    ),
)

finetuned_models = {
    "llama-3-swallow": "tokyotech-llm/Llama-3-Swallow-8B-v0.1",
}

finetuned_param_name_convert_fns = {}

metrics = ["rouge_l_ja"]
use_metrics = ["rouge_l_ja"]
direction = ["maximize"]

exclude_param_names_regex = ""

dare = DAREConfig(
    mask_rate_type="each",
    use_weight_rescale={
        "vlm": True,
        "llama-3-swallow": True,
    },
    mask_strategy={
        "vlm": "random",
        "llama-3-swallow": "random",
    },
)

ties = TiesConfig(
    param_mask_type="same",
    scaling_coefficient=None,
    use_each_model_weight=False,
)

img_size = (512, 512)
