# from sumeval.metrics.rouge import RougeCalculator

import MeCab
from rouge_score import rouge_scorer
from rouge_score.tokenizers import Tokenizer

# def rouge_l_ja(test: str, ref: str) -> float:
#     rouge = RougeCalculator(stopwords=True, lang="ja")
#     return rouge.rouge_l(
#         summary=test,
#         references=ref,
#     )


def rouge_l_en(test: str, ref: str) -> float:
    pass
    # rouge = RougeCalculator(stopwords=True, lang="en")
    # return rouge.rouge_l(
    #     summary=test,
    #     references=ref,
    # )


class MeCabTokenizer(Tokenizer):
    """rouge-score用のMeCabを用いたTokenizerクラス

    Args:
        use_stemmer (bool, optional): Trueの場合、単語の原型で分割する. Defaults to False.
    """

    def __init__(self, use_stemmer=False):
        self._stemmer = use_stemmer

        self.tagger = MeCab.Tagger()
        self.wakati = MeCab.Tagger("-Owakati")

    def tokenize(self, text):
        return self.wakati.parse(text).split()


def rouge_l_ja(test: str, ref: str) -> float:
    mecab_tokenizer = MeCabTokenizer()
    scorer = rouge_scorer.RougeScorer(
        ["rougeL"], use_stemmer=False, tokenizer=mecab_tokenizer
    )
    return scorer.score(ref, test)["rougeL"].fmeasure
