from types import SimpleNamespace

from scripts.runner.evolve import DAREConfig, TiesConfig
from scripts.utils.pure import MiniCPMConfig

n_trials = 100

data = "select500_1"
target = "ja_select500_0810"
extract_target = "findings"
no_findings = "no_findings_20240810"

num_data = 50

dataset = "simple"

sampler = "cmaes"

fp16 = True
# inference_processes = None

base_model_name = "meta-llama/Meta-Llama-3-8B"

question = "あなたは優秀な放射線科医です。このレントゲン写真を見て、所見文を書いてください。肺・心臓・骨に異常があるかに注目して読影してください。"
vlm = SimpleNamespace(
    name="openbmb/MiniCPM-Llama3-V-2_5",
    minicpm=MiniCPMConfig(
        msgs=[{"role": "user", "content": question}],
        sampling=False,
        temperature=0.7,
        system_prompt="",
        max_new_tokens=128,
    ),
)

finetuned_models = {
    "mmedlm": "Henrychur/MMed-Llama-3-8B",
}

finetuned_param_name_convert_fns = {
    "vlm": lambda s: s.replace("llm.", ""),
}

metrics = ["bleu_ja"]
use_metrics = ["bleu_ja"]
direction = ["maximize"]

exclude_param_names_regex = ""

dare = DAREConfig(
    mask_rate_type="each",
    use_weight_rescale={
        "vlm": True,
        "mmedlm": True,
    },
    mask_strategy={
        "vlm": "random",
        "mmedlm": "random",
    },
)

ties = TiesConfig(
    param_mask_type="same",
    scaling_coefficient=None,
    use_each_model_weight=False,
)

img_size = (512, 512)
