# import evaluate
from nltk.translate.bleu_score import sentence_bleu, SmoothingFunction
import MeCab


# def bleu_ja(test: str, ref: str, tokenizer) -> float:
#     bleu = evaluate.load("bleu")
#     res = bleu.compute(
#         predictions=[test], references=[ref], tokenizer=tokenizer.tokenize
#     )
#     return res["bleu"]

def bleu_1(test: str, ref: str, tokenizer) -> float:
    mecab = MeCab.Tagger("-Owakati")
    reference = mecab.parse(ref)
    candidate = mecab.parse(test)

    smooth_fn = SmoothingFunction().method1
    res = sentence_bleu([reference], candidate, weights=(1, 0, 0, 0), smoothing_function=smooth_fn)
    return res


def bleu_2(test: str, ref: str, tokenizer) -> float:
    mecab = MeCab.Tagger("-Owakati")
    reference = mecab.parse(ref)
    candidate = mecab.parse(test)

    smooth_fn = SmoothingFunction().method1
    res = sentence_bleu([reference], candidate, weights=(0.5, 0.5, 0, 0), smoothing_function=smooth_fn)
    return res