# FORECAST UTTERANCE 

### Setting up SYSTEM
- Install the requirements from "requirements.txt"
- Download the following embeddings and add them to the appropriate folder under "embeddings/"
	- FastText
		- "wiki-news-300d-1M.vec"
	- GloVe
		- "glove.6B.200d.txt"
	- Word2Vec
		- "GoogleNews-vectors-negative300.bin"
- Set up configuration variables
	- Under "src/core/configuration/", there will be a number of "xxxxxx_conf.py" files. Edit the variables inside to configure VIDS
	- Use "src/core/evaluation/global_config.json" to vary the training, hyper parameter search and MRR experiment criterion.
  
### Running MODELS 
- To run a file in the system, use commands like the following for the best experience:
	- python -m src.core.evaluation.console
- For Hyperparameter search:
	- python -m src.core.evaluation.hp_search
	- The output will be saved in: src/data/output/fine_tuning/hp_logs/
- For Fine-Tuning the T5 models:
	- python -m src.utils.data_generation.pretrained.scripts.training.py
	- python -m src.utils.data_generation.pretrained.scripts.dataset_generation_lm.py
- For Fine-Tuning the models:
	- python -m src.core.evaluation.train
	- The output will be saved in:	
		- src/data/output/fine_tuning/training/custom
		- src/data/output/fine_tuning/training/universal 
- Statistical significance test: 	
	- python -m src.utils.stat_method.wilcoxon
	- The output will be saved in:src/data/output/acl/wilcoxon/result.json
- For generating MRR numbers:
	- python -m src.core.evaluation.script
	- The output will be saved in:
		- src/data/output/acl/exp/flight_delay
		- src/data/output/acl/exp/online_delivary
		- src/data/output/acl/exp/student_perf
- For generating F1 of ensemble models:
	- python -m src.core.ensembles.ner_squad_ens
	- The output will be saved in: src/core/ensembles/acl/


- There are a few scripts that will be of interest when running VIDS
	- In "src/core/evaluation/train_schema.py": python -m src.core.evaluation.train_schema
		- Used to fine-tune the extraction models used 
	- In "src/core/evaluation/"
		- console.py: python -m src.core.evaluation.console
			- Runs an interactive terminal with the VIDS agent
			- Modify the dictionary on line 6 to configure it
		- script.py: python -m src.core.evaluation.script
			- Runs the MRR evaluation on the flight_delay dataset
			- Modify configuration.json to edit which configurations are tested
			- Results are stored in "src/data/output/experiments/"
		- compare.py: python -m src.core.evaluation.compare
			- Compares two given configurations on the given dataset & difficulty
			- Modify the dictionary on line 6 to configure it
			- Results are stored in "src/data/output/comparisons/"
	- In "src/core/interface/"
		- data_generation.py
			- Used to generate the artificial training samples
			- Modify "src/core/configuration/datagen_conf.py" to configure
	
	
