from src.core.evaluation import train_schema as trainer
import json


def train():
    trainer.main(
        task='ner',
        universal=False,
        evaluation_only=False,
        dataset_type="csr",
        output_dir="src/data/output/fine_tuning/timing/custom"
        )
    
    trainer.main(
        task='squad',
        universal=False,
        evaluation_only=False,
        dataset_type="csr",
        output_dir="src/data/output/fine_tuning/training/custom"
        )
    
    trainer.main(
        task='ner',
        universal=True,
        evaluation_only=False,
        dataset_type="csr",
        output_dir="src/data/output/fine_tuning/training/custom"
        )
    
    trainer.main(
        task='squad',
        universal=True,
        evaluation_only=False,
        dataset_type="csr",
        output_dir="src/data/output/fine_tuning/training/custom"
        )


def evaluate():
    trainer.main(
        task='ner',
        universal=True,
        evaluation_only=True,
        dataset_type="csr",
        output_dir="src/data/output/fine_tuning/training/universal"
        )
    trainer.main(
        task='squad',
        universal=True,
        evaluation_only=True,
        dataset_type="csr",
        output_dir="src/data/output/fine_tuning/training/universal"
        )

train()
evaluate()