'''
- annotation.py
- This file handles interfacing crucial annotation functions with the proper utilities
'''

# External imports

# Internal imports
from distutils.log import debug
from src.utils.annotation import input_cleaning, bert, roberta, xlnet, distilbert, albert #dialogflow



'''
----------cleanse_input----------
- This function cleans up the input text for later use
-----Inputs-----
- text - The user input to parse
- drop_stop_words - True/False on whether to drop stop words
-----Output-----
- adjusted_text - The cleaned-up text
'''
def cleanse_input(text, drop_stop_words=False):
    adjusted_text = input_cleaning.remove_special_chars(text)
    if drop_stop_words:
        adjusted_text = input_cleaning.drop_stop_words(adjusted_text)
    return adjusted_text


'''
----------load_ner_model----------
- This function loads the NER technique for later use
-----Inputs-----
- model_name - The name of the NER technique to load
-----Output-----
- ner_model - The loaded NER technique
'''
def load_ner_model(model_name, use_default_tokenizer=False, task='ner', model_path=None):
    # if "dialogflow" == model_name:
    #     return dialogflow.load_model()
    # el
    if "bert" == model_name:
        return bert.load_model(use_default_tokenizer, task, model_path)
    elif "roberta" == model_name or "roberta-ee" == model_name or "roberta-qa" == model_name:
        return roberta.load_model(use_default_tokenizer, task, model_path)
    elif "xlnet" == model_name:
        return xlnet.load_model(use_default_tokenizer, task, model_path)
    elif "distilbert" == model_name:
        return distilbert.load_model(use_default_tokenizer, task, model_path)
    elif "albert" == model_name:
        return albert.load_model(use_default_tokenizer, task, model_path)
    print("No NER technique detected.")
    return


'''
----------annotate_text----------
- This function annotates the user input, and isolates any useful words
-----Inputs-----
- text - The user input to parse
- schema - The currently-active user database schema
- active_feature - The currently-active feature in the PeTEL expression
- ner_name - The name of the NER technique to use
- ner - The loaded named entity recognition technique
-----Output-----
- adjusted_text - The cleaned-up text
'''
def annotate_text(text, active_feature, model_name, model, debug=False, task='ner', question=''):
    # if "dialogflow" == ner_name:
    #     return dialogflow.annotate(text, schema, active_feature, ner)
    # el
    if "bert" == model_name:
        return bert.annotate(text, active_feature, model, debug, task, question)
    elif "roberta" == model_name or "roberta-ee" == model_name or "roberta-qa" == model_name:
        return roberta.annotate(text, active_feature, model, debug, task, question)
    elif "xlnet" == model_name:
        return xlnet.annotate(text, active_feature, model, debug, task, question)
    elif "distilbert" == model_name:
        return distilbert.annotate(text, active_feature, model, debug, task, question)
    elif "albert" == model_name:
        return albert.annotate(text, active_feature, model, debug, task, question)
    print("No Model response found")
    return text