'''
- simple_chatbot.py
- This file handles user interaction for VIDS
'''


# External imports
import re

# Internal imports
from src.core.configuration.annotation_conf import *



'''
----------remove_special_chars----------
- Given some user input, remove all scpecial characters
-----Inputs-----
- text - The user input to parse
-----Output-----
- adjusted_text - The user input with special characters removed
'''
def remove_special_chars(text):
    adjusted_text = re.sub('[,.?!\t\n\-; ]+()', ' ', text)
    return adjusted_text.strip()


'''
----------drop_stop_words----------
- Given some user input, remove any pre-defined stop words
-----Inputs-----
- text - The user input to parse
-----Output-----
- adjusted_text - The user input with stop words removed
'''
def drop_stop_words(text):
    adjusted_text = ""
    for word in text.split():
        if word not in STOP_WORDS:
            adjusted_text += word + " "
    return adjusted_text.strip()
