'''
- simple_chatbot.py
- This file handles user interaction for VIDS
'''


# External imports
import numpy as np
import src

# Internal imports
from src.core.configuration import chatbot_conf
from src.core.petel import extended_petel

wiki = {
    'prediction_attr': "prediction_attr description",
    'input_feature': "input feature description, default values",
    'filter_attr': "filter attr description",
    'filter_op': "filter_op description, default values(will scan the previous utterances to precalculate the values)",
    'agg_op': "agg_op description, default values(will scan the previous utterances to precalculate the values)",
    'splits': "number of split done for time series. <more descriptive>. Default values",
    'classifier' : "classifier description. default option describe. ask for using default or other option."
}

def get_next_slot(slots):
    for key in slots:
        value = slots[key]
        if value[0]['val'] == value[len(value) -1]['val']:
            return key

'''
----------get_response----------
- Given some user input, run it through the proper chatbot and return its response
-----Inputs-----
- utterance - The user input for the previous iteration (U_t-1)
- sentiment - The extracted system intent 
- petel_exp - The current petel expression
- schema - The currently-active user database schema
- configuration - The currently-active configuration
- embedding - The loaded embedding
- ner - The loaded named entity recognition technique (Optional)
-----Output-----
- response - A key-value pair of both the text response and the associated PeTEL expression
'''
def get_response(utterance, sentiment, petel, domain, current_slot): #, schema, configuration, embedding, ner=None):
    response = ""
    
    if sentiment == 'info':
        domain_slots = petel.domains[domain]
        current_slot = get_next_slot(domain_slots)
        # if current_slot == ''
        #get value from encoder for the domain, slot pair. 
        #assuming we have a value under the variable slot_val
        slot_val = "value"
        response = "For solving the " + str(domain) + " problem, we need to to know what should be the "  + str(current_slot) + " For this problem. The slot" + wiki[current_slot] + "\nCan you specify its value?"

    elif sentiment == 'welcome':
        response = 'Welcome to VIDS'
    elif sentiment == 'positive':
        print(sentiment)
    elif sentiment == 'explain':
        print(sentiment)
    elif sentiment == 'example':
        print(sentiment)
    elif sentiment == 'confirm':
        # if current_slot == ''
        #get value from encoder for the domain, slot pair. 
        #assuming we have a value under the variable slot_val
        slot_val = "value"
        response = "For solving the " + str(domain) + " problem, we need to to know what should be the "  + str(current_slot) + " For this problem. The slot" + wiki[current_slot]

        print(sentiment)
    else: #negative
        print(sentiment)

    # Return the response and the PeTEL expression
    return {"expression": petel, "response": response, "slot": current_slot}


petel_exp = extended_petel.petel()
response = get_response('predict the average weather delay', 'info', petel_exp, 'linear_regression', 'prediction_attr')

print(response['response'])