'''
- intent.py
- This file handles intent detection for VIDS
'''


# External imports

# Internal imports



'''
----------simple_detection----------
- Given some user input, extract the intent based on certain keywords and return it
-----Inputs-----
- text - The user input to parse
-----Output-----
- intent - The extracted intent for the given query
'''


def simple_detection(text):
    # This can probably be somewhat improved upon
    if 'predict' in text or 'find' in text:
        return 'query'
    elif 'i want to know' in text or 'find' in text:
        return 'query'
    elif 'can you tell me' in text or 'find' in text:
        return 'query'
    elif 'wanna know' in text or 'find' in text:
        return 'query'
    elif 'hi' == text or 'hello' == text:
        return 'welcome'
    elif 'yes' == text or 'yep' in text == 'yeah' in text:
        return 'yes_wo_info'
    elif 'no' == text or 'not quite' == text:
        return 'no_wo_info'
    elif 'list' in text:
        return 'list'
    
    return 'info'


'''
----------detection with annotation----------
- Given some user input, extract the intent based on certain keywords and return it
-----Inputs-----
- text - The user input to parse
- annotation - text annotated by ner
-----Output-----
- intent - The extracted intent for the given query
'''
def detect_with_annotated_text(text, annotation):
    has_info = (len(annotation['attribute']) > 0 or len(annotation['filter']) > 0 
                or len(annotation['filter_operation']) > 0 or len(annotation['aggregator']) > 0 or len(annotation['prediction_window']) > 0 )
    
    # This can probably be somewhat improved upon
    if ('predict' in text or 'find' in text) and has_info:
        return 'query'
    elif ('i want to know' in text or 'find' in text) and has_info:
        return 'query'
    elif ('can you tell me' in text or 'find' in text) and has_info:
        return 'query'
    elif ('wanna know' in text or 'find' in text) and has_info:
        return 'query'
    elif ('hi' in text or 'hello' in text) and not has_info:
        return 'welcome'
    elif ('hi' == text or 'hello' == text):
        return 'welcome'
    elif ('yes' == text or 'yep' == text or 'yeah' == text):
        return 'yes_wo_info'
    elif ('no' == text or 'not quite' == text):
        return 'no_wo_info'
    elif ('yes' in text or 'yep' in text or 'yeah' in text) and has_info:
        return 'yes_w_info'
    elif ('yes' in text or 'yep' in text or 'yeah' in text) and not has_info:
        return 'yes_wo_info'
    elif ('no' in text or 'not quite' in text) and has_info:
        return 'no_w_info'
    elif ('no' in text or 'not quite' in text) and not has_info:
        return 'no_wo_info'
    elif has_info:
        return 'info'
    elif 'list' in text:
        return 'list'
    
    return 'undetermined'