'''
- annotate.py
- This file handles annotation of user input
'''


# External imports
from distutils.log import debug
from pyexpat import features
import numpy as np

# Internal imports
from src.core.configuration import chatbot_conf
from src.core.interface import annotation, ranking


'''
----------get_response----------
- Given some user input, run it through the proper chatbot and return its response
-----Inputs-----
- text - The user input to parse
- petel_exp - The current petel expression
- configuration - The currently-active configuration
- ner - The loaded named entity recognition technique (Optional)
-----Output-----
- response - A key-value pair of both the text response and the associated PeTEL expression
'''
def get_annotation(text, petel_exp, configuration, model=None, debug=False, task='ner'):
    annotated_text = {}
    question_map = {
        "attribute": "what is the target attribute?",
        "aggregator": "what is the target aggregator?",
        "filter": "what is the target filtering attribute?",
        "filter_operation": "what is the target filtering operator?",
        "prediction_window": "what is the prediction window?",
        "number": "what number is used?",
        "entity": "what is the target entity?"
    }
    if not model:
        return annotated_text
    for feature in petel_exp.flags:
        if task == 'ner':
            feature_annotation = annotation.annotate_text(text, feature, configuration["model"], model, debug=debug, task=task, question='')
        elif task == 'squad':
            question = question_map[feature]
            feature_annotation = annotation.annotate_text(text, feature, configuration["model"], model, debug=debug, task=task, question=question)
        annotated_text[feature] = feature_annotation
    return annotated_text

'''
----------cleanse_input----------
- This function cleans up the input text for later use
-----Inputs-----
- text - The user input to parse
- drop_stop_words - True/False on whether to drop stop words
-----Output-----
- adjusted_text - The cleaned-up text
'''
def cleanse_input(text, drop_stop_words=False):
    return annotation.cleanse_input(text, drop_stop_words)
