
#compute precision, recall and f1 from prediction and ground truth.
def compute_f1_precision_recall(predictions, ground_truths, file_path):
    true_positive_overall = 0
    true_positive_ent = 0
    true_positive_atr = 0
    false_positive_overall = 0
    false_positive_ent = 0
    false_positive_atr = 0
    false_negetive_overall = 0
    false_negetive_ent = 0
    false_negetive_atr = 0
    file = open(file_path, 'a')

    for i in range(0, len(ground_truths)):
        pred = predictions[i]
        g_truth = ground_truths[i]
        length = len(pred)
        for j in range(0, length):
            if pred[j] != 'O':
                if pred[j] == g_truth[j]:
                    true_positive_overall += 1
                    if pred[j] == 'I-ATR':
                        true_positive_atr += 1
                    if pred[j] == 'I-ENT':
                        true_positive_ent += 1
                else:
                    false_positive_overall += 1
                    if pred[j] == 'I-ATR':
                        false_positive_atr += 1
                    if pred[j] == 'I-ENT':
                        false_positive_ent += 1
            else:
                if g_truth[j] != 'O':
                    false_negetive_overall += 1
                    if g_truth[j] == 'I-ATR':
                        false_negetive_atr += 1
                    if g_truth[j] == 'I-ENT':
                        false_negetive_ent += 1
    print('true_positive_overall', true_positive_overall ,
    'true_positive_ent' , true_positive_ent,
    'true_positive_atr' , true_positive_atr,
    'false_positive_overall' , false_positive_overall,
    'false_positive_ent' , false_positive_ent,
    'false_positive_atr' , false_positive_atr,
    'false_negetive_overall' , false_negetive_overall,
    'false_negetive_ent' , false_negetive_ent,
    'false_negetive_atr', false_negetive_atr)

    if (true_positive_overall + false_positive_overall) == 0:
        precision = 0
    else:
        precision = true_positive_overall / (true_positive_overall + false_positive_overall)
    if (true_positive_overall + false_negetive_overall) == 0:
        recall = 0
    else:
        recall = true_positive_overall / (true_positive_overall + false_negetive_overall)
    if precision == 0 and recall == 0:
        f_1 = 0
    else:
        f_1 = (2 * precision * recall) / (precision + recall)
    file.write('\nOverall:')
    file.write(('\nPrecision: ' + str(precision)))
    file.write(('\nRecall: ' + str(recall)))
    file.write(('\nF1: ' + str(f_1)))

    print('\nOverall:')
    print(('\nPrecision: ' + str(precision)))
    print(('\nRecall: ' + str(recall)))
    print(('\nF1: ' + str(f_1)))

    if (true_positive_ent + false_positive_ent) == 0:
        precision = 0
    else:
        precision = true_positive_ent / (true_positive_ent + false_positive_ent)
    if (true_positive_ent + false_negetive_ent) == 0:
        recall = 0
    else:
        recall = true_positive_ent / (true_positive_ent + false_negetive_ent)
    if precision ==0 and recall == 0:
        f_1 = 0
    else:
        f_1 = (2 * precision * recall) / (precision + recall)
    file.write('\nEntity:')
    file.write(('\nPrecision: ' + str(precision)))
    file.write(('\nRecall: ' + str(recall)))
    file.write(('\nF1: ' + str(f_1)))

    if (true_positive_atr + false_positive_atr) == 0:
        precision = 0
    else:
        precision = true_positive_atr / (true_positive_atr + false_positive_atr)
    if (true_positive_atr + false_negetive_atr) ==0:
        recall = 0
    else:
        recall = true_positive_atr / (true_positive_atr + false_negetive_atr)
    if precision ==0 and recall == 0:
        f_1 = 0
    else:
        f_1 = (2 * precision * recall) / (precision + recall)
    file.write('\nAttribute:')
    file.write(('\nPrecision: ' + str(precision)))
    file.write(('\nRecall: ' + str(recall)))
    file.write(('\nF1: ' + str(f_1)))