'''
- glove.py
- This file handles the loading and distance measuring of glove embeddings
'''

# External imports
import numpy as np
import tensorflow_hub as hub
import tensorflow as tf

# Internal imports


'''
----------load_embedding----------
- This function loads in the current feature vector set to work with
-----Inputs-----
- file_location - the location of the fasttext embedding file to use
-----Output-----
- embedding - the dictionary of embeddings
'''
def load_embedding(file_location):
    embed = hub.load("https://tfhub.dev/google/universal-sentence-encoder/4")
    return {"embedding": embed}


'''
----------get_avg_text_vector----------
- This function loads in the current feature vector set to work with
-----Inputs-----
- text - the text whose average embedding is to be retrieved
- embedding - the name of the embedding to use
-----Output-----
- distance - the averaged
'''
def get_avg_text_vector(text, embedding):
    #use vector embed
    with tf.device('/CPU:0'):
        vector = embedding([text])
    return vector


'''
----------load_finetuned_embedding----------
- This function loads in the current feature vector set to work with
-----Inputs-----
- file_location - the location of the fasttext embedding file to use
-----Output-----
- embedding - the dictionary of embeddings
'''


'''
----------get_finetuned_avg_text_vector----------
- This function loads in the current feature vector set to work with
-----Inputs-----
- embedding - the name of the embedding to use
- schema - the currently-active schema
-----Output-----
- embedding - the dictionary of embeddings
'''