function dialog_tree(text, expression, schema)
{
    var response = '';

    // Get the user's intent for the current statement
    var intent = http_get('/intents?text=' + text)

    // Based on the intent, perform an action:
    switch(intent)
    {
        case 'welcome':
            response = "Welcome to VIDS, I am your Virtual Data Science Assistant! I'm here to help you with your prediction needs and goals! "
            response += "Just tell me in plain English what prediction task you want to solve. For example, you can ask me questions like: "
            response +="\"I want to predict the average delay for each origin airport over the next week.\"";
            break;
        case 'query':
            // Reset the PeTEL expression
            expression = new petel_exp();

            // First, update the PeTEL expression with the appropriate rankings
            expression.update_all(text, schema);

            // Generate the response
            response = `Thank you! It looks like the target ${expression.active_feature} of your `
            response += `goal prediction task is ${expression.values[expression.active_feature][0]['name']}, is that correct?`;
            break;
        case 'yes':
            if (expression.is_complete())
            {
                // Mark the expression as valid
                expression.valid = true;

                // Generate the response
                response = "Fantastic! Thanks for talking through it with me!";
                break;
            }
            // Otherwise, mark the current part of the expression as 'done' and move on
            expression.finished_feature();

            // Generate the response
            response = 'Thanks for confirming!\n';
            if (expression.is_complete())
            {
                response += `So this is the problem you're trying to solve:\n`
                response += `Predict the ${expression.values['attribute'][0]['name']} for each `
                response += `${expression.values['entity'][0]['name']}. Is that correct?`;
            }
            else
            {
                response += `So now, let's focus on the target ${expression.active_feature} of your `
                response += `goal prediction task. It looks like you're interested in the ${expression.active_feature} `
                response += `${expression.values[expression.active_feature][0]['name']}, is that correct?`;
            }
            break;
        case 'no':
            // Mark the current suggestion as false, and update the rankings for the active feature
            expression.falsify(0);
            expression.update_active(text, schema);

            // Generate the response
            response = `Okay, so then is your target ${expression.active_feature} the ${expression.values[expression.active_feature][0]['name']}?`;
            break;
        default:
            response = "I'm sorry, I don't really know what your intent is. Please try making your statement a bit more clear.";
            break;
    }

    // Return the updated expression and current response
    return {"expression":expression, "response":response};
}