'''
- fine_tuning_conf.py
- This file handles the global configuration for the fine_tuning methods used in VIDS
'''

# Hyperparameter search space
# WEIGHT_DECAYS = [0.1]
WEIGHT_DECAYS = [0.01, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3]
LEARNING_RATES = [1.00E-05, 5.00E-05, 7.50E-05, 1.00E-4, 5.00E-4, 7.50e-4]
HP_SEARCH_DATA_SIZE = 10592

# Model storage
FINISHED_MODEL_LOC = "models/"
TEMP_MODEL_LOC = "models/temp/"

# Default Parameters
DEFAULT_TRAINING_PARAMETERS = {
    "data_dir":"",#
    "model_type":"",#
    "model_name_or_path":"",#
    "output_dir":"",#
    "labels":"",
    "config_name":"",
    "tokenizer_name":"",#
    "cache_dir":"",
    "max_seq_length":64,
    "do_train":True,
    "do_eval":True,
    "do_predict":True,
    "evaluate_during_training":True,
    "eval_mode":"valid",
    "do_lower_case":False,
    "per_gpu_train_batch_size":64,
    "per_gpu_eval_batch_size":2,
    "gradient_accumulation_steps":1,
    "learning_rate":0,#
    "weight_decay":0,#
    "adam_epsilon":1e-8,
    "max_grad_norm":1.0,
    "num_train_epochs":3.0,
    "max_steps":-1,
    "warmup_steps":0,
    "logging_steps":8000,
    "save_steps":8000,
    "eval_all_checkpoints":True,
    "no_cuda":False,
    "overwrite_output_dir":True,
    "overwrite_cache":False,#
    "seed":42,
    "fp16":False,
    "fp16_opt_level":"O1",
    "local_rank":-1,
    "server_ip":"",
    "server_port":"",
    "is_hyper_parameter_search": False
}
