'''
- console.py
- This file runs a sample interaction in the commandline for debugging individual scenarios
'''

configuration = {
    "model":"xlnet",
    "embedding":"use",
    "similarity_function":"cosine",
    "schema":"student_perf",
    "task": "ner",
    "model_path": "models/ner/student_perf/xlnet/xlnet"
}


# Internal imports
from src.core.petel.petel import *
import src.core.interface.ranking as ranking
import src.core.interface.dialog as dialog
import src.core.interface.annotation as annotation
from src.utils.misc.schema import load_schema


def start():
    # Load the schema
    schema_file = open('src/data/test_data/schema/' + configuration["schema"] + '.schema', "r")
    loaded_schema = load_schema(schema_file.read())
    schema_file.close()

    # Initialize the session by loading the embedding and NER technique
    loaded_embedding = ranking.load_embedding(configuration["embedding"], loaded_schema)
    print("LOADING: Loaded the embedding:", configuration["embedding"])
    loaded_model = annotation.load_ner_model(configuration["model"], task=configuration["task"], model_path=configuration["model_path"])
    print("LOADING: Loaded the Information Extraction Model:", configuration["model"])

    # Fire up the session
    user_input = 'Hi'
    petel_exp = petel(loaded_schema)
    while (user_input != 'exit'):
        # Run the query through VIDS
        response = dialog.run(user_input, petel_exp, loaded_schema, configuration, loaded_embedding, loaded_model, debug=True, task=configuration["task"])
        #response = run_dialogue(user_input, petel_exp, loaded_schema, configuration["embedding"], loaded_embedding, configuration["similarity_function"], configuration["ner"], loaded_ner_model)

        # Update the PeTEL expression
        petel_exp = response["expression"]

        # Output VIDS' response
        print(response["response"])
        # print(petel_exp.rankings)

        # Accept user input
        user_input = input("> ")

start()